//PIC8 code for ILI9341 and XPT2046 modules

#include <xc.h>
#include "portbits.h"
#include "fonts.h"

#ifndef LCD_BACKPACK_H    /* Guard against multiple inclusion */
#define LCD_BACKPACK_H

//pin designations
#define BACKPACK_BACKLIGHT c5
#define BACKPACK_CS c6
#define BACKPACK_DC b7
#define BACKPACK_RST a2
#define BACKPACK_TOUCHCS b5
#define SPI_MOSI c7
#define SPI_MISO b4
#define SPI_SCK b6

//pinout for PIC16F18146 Multi-channel volume master
//2     RA5 CS_3
//3     RA4 CS_1
//5     RC5 LEDCON
//6     RC4 CS_2
//7     RC3 SHDN_DP
//8     RC6 LCD_CS
//9     RC7 MOSI (HW)
//10    RB7 LCD_DC
//11    RB6 SCK (HW)
//12    RB5 TOUCH_CS
//13    RB4 MISO (HW)
//14    RC2 IR_RX
//15    RC1 CS_5
//16    RC0 CS_4
//17    RA2 LCD_RST

#define delay(x) __delay_ms(x)

//for ILI9341
#define Z_TOUCH_THRESHOLD 40
#define TOUCH_A (11612L)
#define TOUCH_B 0
#define TOUCH_C (-1056568L)
#define TOUCH_D 0
#define TOUCH_E (8411L)
#define TOUCH_F (-761160L)
#define TOUCH_OVERSAMPLE 16

//defaults  are 0/2 for max speed, 10 uses SSPADD
#define LCD_BRG (0)
//#define LCD_BRG (2)
//#define LCD_BRG (10)
#define TOUCH_BRG (2)
//#define TOUCH_BRG (10)
#define SPI_BRG SSP1CON1bits.SSPM

//some nice colour names
#define BLACK 0x0000
#define BLUE 0x001F
#define RED 0xF800
#define GREEN 0x07E0
#define CYAN 0x07FF
#define MAGENTA 0xF81F
#define YELLOW 0xFFE0  
#define WHITE 0xFFFF
//#define GREY 0x8410
#define GREY 0x4208
#define ORANGE (RED|(GREEN&(GREEN/2)))
//unit colours - multiply by 0-31
#define RED_1 0x0800
#define GREEN_1 0x0040
#define BLUE_1 0x0001

#define BUTTON_FORE WHITE
#define BUTTON_BACK BLACK
#define BUTTON_FONT arial_bold12x16
#define HLINE_BUFSIZE 64

struct backpackbutton{      //core button features, colour/font set by style defines
    unsigned int x0;
    unsigned int y0;
    unsigned int w;
    unsigned int h;
    const char *text;
//    char p:1;
//    char pp:1;
    char p; //pressed
    char pp;//pressed on last draw
};

extern unsigned int backpackwidth,backpackheight,backpackrotation;
extern const unsigned char seg7bm[];

void getDigits(unsigned int n,unsigned char* d);
void backpackinit(void);
void backpackSPIinit(void);
void backpackrotate(char a);
void backpackdata(unsigned char d);
void backpackcmd(unsigned char d);
unsigned int backpackSPI16(unsigned int n);
void backpackareaset(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2);    
void backpackbox(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2,unsigned int c);  
void backpackboxsize(unsigned int x1,unsigned int y1,unsigned int w,unsigned int h,unsigned int c);
void backpackclear(unsigned int c);
void backpackpoint(unsigned int x,unsigned int y, unsigned int c);
unsigned int backpackcharfonts(unsigned int x, unsigned int y, char c, unsigned int f, unsigned int b, const unsigned char* font,unsigned char s);
unsigned int backpackcharfont2(unsigned int x, unsigned int y, char c, unsigned int f, unsigned int b, const unsigned char* font);//fixed x2 scaling
unsigned int backpackcharfont(unsigned int x, unsigned int y, char c, unsigned int f, unsigned int b, const unsigned char* font);
void backpackchararrayfont(unsigned int x0, unsigned int y0, const char *c, unsigned int f, unsigned int b, const unsigned char* font);
void backpackchararrayfont2(unsigned int x0, unsigned int y0, const char *c, unsigned int f, unsigned int b, const unsigned char* font);
unsigned int backpacktouchxraw(void);  //raw adc
unsigned int backpacktouchyraw(void);
unsigned int backpacktouchzraw(void);
int backpacktouchx(void);     //scaled, rotated, pixel reference, fixed  for rotate 2
int backpacktouchy(void);

void backpackhline(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int c);
void backpackvline(unsigned int x1,unsigned int y1,unsigned int y2,unsigned int c);

void backpacktextbutton(unsigned int x1,unsigned int y1,unsigned int x2,unsigned int y2, const char *c,unsigned int f,unsigned int b,const unsigned char* font);
void backpacksetbuttonobject(struct backpackbutton *b,unsigned int x0,unsigned int y0,unsigned int x1,unsigned int y1, const char *text);
void backpackbuttonrefresh(struct backpackbutton *b);
char backpackbuttonobjecttouched(struct backpackbutton *b);
char backpackbuttonobjecttouchedinv(struct backpackbutton *b);  //check for reverse
void backpackdrawbuttonobject(struct backpackbutton *b, unsigned int f,unsigned int bg,const unsigned char* font);

void backpackbuttonupdate(struct backpackbutton *b);
char backpackbuttowndownevent(struct backpackbutton *b);

void backpackBacklight(char n);      //set backlight in %
void backpackBacklightInit(void);       //PWM setup etc

void drawbitmapmono(unsigned int x0, unsigned int y0,const unsigned char* bm,unsigned int f,unsigned int b);   //draw mono bitmap with colours f and b
void drawbitmapmonoRLE(unsigned int x0, unsigned int y0,const unsigned char* bm,unsigned int f,unsigned int b);   //draw RLE mono bitmap with colours f and b
void drawbitmapmonoRLE4(unsigned int x0, unsigned int y0,const unsigned char* bm,unsigned int f,unsigned int b);    //draw RLE4 mono bitmap with colours f and b
unsigned int backpackcharfontRLE(unsigned int x, unsigned int y, char c, unsigned int f, unsigned int b, const unsigned char* font);

#endif /* LCD_BACKPACK_H */
